﻿using System;
using System.Collections.Generic;
using System.Reflection;
using System.Linq;
using System.Text;

using UnityEngine;
using Verse;
using RimWorld;
using Harmony;

namespace SSDetours
{
    [HarmonyPatch(typeof(IncidentWorker_ShortCircuit)), HarmonyPatch("TryExecute")]
    public static class IncidentWorker_SSShortCircuit
    {
        public static IEnumerable<Building> UsableBatteries(Map map)
        {
            return
                from Building battery in map.listerBuildings.allBuildingsColonist
                where (battery.TryGetComp<CompPowerBattery>() != null
                        && battery.TryGetComp<CompPowerBattery>().StoredEnergy > 50f)
                select battery;
        }
        
        /// <summary>
        /// Combination of Ratys's code from Fuse and original Core code. Shouldn't conflict with RT Fuse.
        /// </summary>
        [HarmonyPriority(0)]
        public static void Postfix(IncidentParms parms, IncidentWorker_ShortCircuit __instance, ref bool __result)
        {
            if (__result) return;
            //Redo calculation with new parameters
            Map map = (Map)parms.target;
            List<Building> batteries = UsableBatteries(map).ToList();
            if (batteries.Count() == 0) __result = false;
            PowerNet powerNet = batteries.RandomElement().PowerComp.PowerNet;
            List<CompPower> victims = (
                from transmitter in powerNet.transmitters
                where transmitter.parent.def == ThingDefOf.PowerConduit
                select transmitter
                ).ToList();
            if (victims.Count == 0) __result = false;

            float energyTotal = 0.0f;
            foreach (CompPowerBattery battery in powerNet.batteryComps)
            {
                energyTotal += battery.StoredEnergy;
                battery.DrawPower(battery.StoredEnergy);
            }

            float energyTotalHistoric = energyTotal;

            StringBuilder stringBuilder = new StringBuilder();
            Thing victim = victims.RandomElement().parent;

            if (energyTotal > 0)
            {
                float explosionRadius = Mathf.Sqrt(energyTotal) * 0.05f;
                if (explosionRadius > 14.9f) explosionRadius = 14.9f;

                GenExplosion.DoExplosion(
                    victim.Position, map, explosionRadius, DamageDefOf.Flame,
                    null, null, null, null, null, 0f, 1, false, null, 0f, 1);

                if (explosionRadius > 3.5f)
                    GenExplosion.DoExplosion(
                        victim.Position, map, explosionRadius * 0.3f, DamageDefOf.Bomb,
                        null, null, null, null, null, 0f, 1, false, null, 0f, 1);

                if (!victim.Destroyed)
                    victim.TakeDamage(new DamageInfo(
                        DamageDefOf.Bomb, 200, -1f, null, null));

                if (energyTotal == energyTotalHistoric)
                {
                    stringBuilder.Append("ShortCircuit".Translate(new object[]
                    {
                        "AnElectricalConduit".Translate(),
                        energyTotalHistoric.ToString("F0")
                    }));
                }

                if (explosionRadius > 5f)
                {
                    stringBuilder.AppendLine();
                    stringBuilder.AppendLine();
                    stringBuilder.Append("ShortCircuitWasLarge".Translate());
                }

                if (explosionRadius > 8f)
                {
                    stringBuilder.AppendLine();
                    stringBuilder.AppendLine();
                    stringBuilder.Append("ShortCircuitWasHuge".Translate());
                }
            }

            Find.LetterStack.ReceiveLetter(
                "LetterLabelShortCircuit".Translate(), stringBuilder.ToString(),
                LetterDefOf.BadNonUrgent, new TargetInfo(victim.Position, map, false), null);

            __result = true;
        }
    }

    [HarmonyPatch(typeof(Alert_NeedBatteries)), HarmonyPatch("NeedBatteries")]
    static class Patch_NeedBatteries
    {
        public static void Postfix(Map map, ref bool __result)
        {
            if (__result)
            {
                __result = map.IsPlayerHome && IncidentWorker_SSShortCircuit.UsableBatteries(map).ToList().Count == 0;
            }
        }
    }

    /// <summary>
    /// Powered by Harmony
    /// </summary>
    [StaticConstructorOnStartup]
    internal static class DetourInjector
        {
            static DetourInjector()
            {
                LongEventHandler.QueueLongEvent(Inject, "LibraryStartup", false, null);
            }

            public static void Inject()
            {
                HarmonyInstance.Create("com.spdskatr.biggerbatteries.injector").PatchAll(Assembly.GetExecutingAssembly());
                Log.Message("SS Bigger Batteries information for modders(not an error)\n This mod uses Harmony postfixes(non-destructive) on the following methods:\nRimWorld.IncidentWorker_ShortCircuit.TryExecute,\nRimWorld.Alert_NeedBatteries.NeedBatteries\n\nSTACK TRACE BELOW\n\n");
            }
        }
    }